#ifndef _STRINGPARSER_H
#define _STRINGPARSER_H

#include <string>
#include <stdio.h>
#include <fstream>
#include "Vector.h"

using namespace std;

class StringParser {
public:
	StringParser(const char * _data = 0, const char _delim = ' ');
	
	StringParser & operator = (const StringParser & sp);
	
	StringParser(const StringParser & sp);
	
	~StringParser();

	void data(const char * _data);
	
	char * data() const;
	char * nextToken();
	bool hasMoreTokens() const;
	int countTokens() const;
	
	bool operator == (const StringParser & sp) const;
	bool operator != (const StringParser & sp) const;
		
	void printOn(ostream & o) const;

private:
	void setTokenCount();

	int _index;
	int _currentToken;
	int _tokenCount;
	char _delim;
	char * _data;
};

ostream & operator << (ostream & o, const StringParser & sp);

#endif